% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bessel_y}
\alias{bessel_y}
\title{The BesselY Function}
\usage{
bessel_y(z, nu, expon_scaled = FALSE, verbose = 0)
}
\arguments{
\item{z}{A numeric or complex vector representing the input values at which to evaluate the Bessel function.}

\item{nu}{A double representing the order of the Bessel function.}

\item{expon_scaled}{A logical value indicating whether to use the exponentially scaled form of the Bessel function. Defaults to \code{FALSE}.}

\item{verbose}{An integer specifying the verbosity level for error messages. Defaults to \code{0}.}
}
\value{
A numeric or complex vector (depending on the input) containing the values of the \code{bessel_y} function evaluated at the points in \code{z}.
}
\description{
Computes the Bessel function of the second kind (Neumann function) for real or complex inputs.
}
\references{
{
\insertRef{Maechler2024}{RcppBessel}\cr
\insertRef{Amos1995}{RcppBessel}
}
}
