% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bessel_h}
\alias{bessel_h}
\title{The BesselH Function}
\usage{
bessel_h(m, z, nu, expon_scaled = FALSE, verbose = 0)
}
\arguments{
\item{m}{An integer representing the type of Hankel function. It must be either \code{1} (for the first kind) or \code{2} (for the second kind).}

\item{z}{A numeric or complex vector representing the input values at which to evaluate the Hankel function.}

\item{nu}{A double representing the order of the Hankel function.}

\item{expon_scaled}{A logical value indicating whether to use the exponentially scaled form of the Hankel function. Defaults to \code{FALSE}.}

\item{verbose}{An integer specifying the verbosity level for error messages. Defaults to \code{0}.}
}
\value{
A complex vector containing the values of the \code{bessel_h} function evaluated at the points in \code{z}.
}
\description{
Computes the Hankel function (Bessel function of the third kind) for real or complex inputs.
}
\references{
{
\insertRef{Maechler2024}{RcppBessel}\cr
\insertRef{Amos1995}{RcppBessel}
}
}
