% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logistic_solve1}
\alias{logistic_solve1}
\title{logistic_fit}
\usage{
logistic_solve1(x, y, w, initial_link, i, j, skip)
}
\arguments{
\item{x}{NumericVector, expanatory variable.}

\item{y}{NumericVector, 0/1 values to fit.}

\item{w}{NumericVector, weights (required, positive).}

\item{initial_link, }{initial link estimates (required, all zeroes is a good start).}

\item{i}{integer, first index (inclusive).}

\item{j}{integer, last index (inclusive).}

\item{skip}{integer, index to skip (-1 to not skip).}
}
\value{
vector of a and b.
}
\description{
Calculate y ~ sigmoid(a + b x) using iteratively re-weighted least squares.
Zero indexed.
}
\examples{

set.seed(5)
d <- data.frame(
  x =  rnorm(10),
  y = sample(c(0,1), 10, replace = TRUE)
)
weights <- runif(nrow(d))
m <- glm(y~x, data = d, family = binomial, weights = weights)
coef(m)
logistic_solve1(d$x, d$y, weights, rep(0.0, nrow(d)), 0, nrow(d)-1, -1)

}
\keyword{internal}
