
\name{sourceCppAD}
\alias{sourceCppAD}
\title{Construct a function to calculate the Jacobian of a function.}
\usage{
sourceCppAD(code=NULL,file=NULL,wrt=1,output="method")
}
\arguments{
  \item{code}{A character vector containing the C++ code to compile.}
  \item{file}{The filename of a file containing the C++ code to compile.}
  \item{wrt}{The position of the argument that \code{\link{J}} and \code{\link{H}} are differentiated with respect to.}
  \item{output}{Specifies what is generated by sourceCppAD. If
    output="method" (the default) then a function which invokes the compiled code is
    returned. If output="code" then the source code that wraps
    the users function for use with the algorithmic differentiation
    libraries is returned.}
}
\value{
A function which invokes the compiled code or the c++ code that wraps
the users function for use with the algorithmic differentiation libraries.
}
\description{
Constructs an R function that wraps a call to a C++ function and compiles the
C++ code used to define the function.
The code must define a function having arguments of the type const ADmat& and
a return type of ADmat. The ADmat type is a type definition for a dynamically sized
matrix from the Eigen linear algebra library. (Guennebaud G, Jacob B and
others 2010). The function can employ methods from the Eigen library, such as all of the standard
operators from linear algebra, and a wide range of
functions for calculating inverses, decompositions and so on. See Guennebaud G, Jacob B and
others (2010) for further details.

The returned function can then be used
as an argument to \code{\link{J}} or \code{\link{H}} which provide functions that apply algorithmic differentiation
to calculate the Jacobian or Hessian matrices. The functions produced by \code{J} or \code{H} evaluate
the partial derivatives with respect to the elements of the argument located at the position in the functions argument
list that is specified by the \code{wrt} argument of sourceCppAD. 
}
\examples{
\donttest{
library(RcppEigenAD)
# define a function to calculate sin(cos(x)) where x is a matrix
f<-sourceCppAD('
ADmat f(const ADmat& X)
{
  return X.array().cos().sin();
}
')
x<-matrix(c(1,2,3,4),2,2)
# call it
f(x)
}
}
\references{
\insertRef{eigenweb}{RcppEigenAD}
}