% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperfect_competition.R
\name{stackelberg_solver}
\alias{stackelberg_solver}
\title{Stackelberg Duopoly with numeric solution}
\usage{
stackelberg_solver(leader = c(0, 1), follower = c(0, 1),
  demand = c(0, -1), l0 = 0, f0 = 0)
}
\arguments{
\item{leader}{vector of coefficients of the leader's cost function which in order must be: intercept of leader's cost function and linear term's parameter of leader's cost function}

\item{follower}{vector of coefficients of the follower's cost function which in order must be: intercept of intercept of follower's cost function linear term's parameter of follower's cost function}

\item{demand}{vector of coefficients of the market demand curve. Must be, in order, intercept and linear coefficient.}

\item{l0}{Initial guess for leader's output. Defaults to 0. Strongly advised not to set this parameter unless you are very aware of what you're doing.}

\item{f0}{Initial guess for follower's output. Defaults to 0. Strongly advised not to set this parameter unless you are very aware of what you're doing.}
}
\value{
A list with market price, firm output, profits and market share
}
\description{
This function numerically finds the equilibrium in a Stackelberg duopoly model with linear functions. For guaranteed existence of equilibrium, cost parameters should be non-negative.
The general functional form for a function of argument x is \eqn{f(x) = p_0 + p_1 x}. Parameters p refer to the inverse demand function.
The firm indexed by "l" is the leader, and the one indexed by "f" is the follower.
}
\examples{

l = c(100, 4)
f = c(120, 5)
p = c(300, -10)
stackelberg_solver(leader = l, follower = f, demand = p)

}
\author{
Pedro Cavalcante Oliveira, Department of Economics, Fluminense Federal University \email{pedrocolrj@gmail.com}
}
