\name{getExpectedSize}
\alias{getExpectedSize}
\alias{getExpectedSize-methods}
\alias{getExpectedSize,RLBigDataDedup-method}
\alias{getExpectedSize,RLBigDataLinkage-method}
\alias{getExpectedSize,data.frame-method}

\title{
  Estimate number of record pairs.
}
\description{
  Estimates the total number of record pairs generated by a dataset and
  specified blocking conditions.
}
\usage{
  getExpectedSize(object, ...)

  \S4method{getExpectedSize}{RLBigDataDedup}(object)

  \S4method{getExpectedSize}{RLBigDataLinkage}(object)

  \S4method{getExpectedSize}{data.frame}(object, blockfld = list())
}

\arguments{
  \item{object}{
    Either a record linkage object or a dataset.
  }
  \item{blockfld}{A blocking definition, such as in \code{\link{compare.dedup}}}
  \item{\dots}{
    Placeholder for additional arguments.
  }
}
\details{
  The \code{"RLBigData*"} methods are only left for backward compatibility.
  Since version 0.4, all record pairs for such objects are generated and stored
  in a disk file. The methods return the true number of record pairs.

  For the \code{"data.frame"} method, estimation is based on the assumption
  that agreement or disagreement of one attribute is independent of the other attributes.
  
  \code{blockfld} is a blocking definition such as for
  \code{\link{RLBigDataDedup}}.
}
\value{
  The expected number of record pairs.
}
\author{
  Andreas Borg, Murat Sariyar
}


\keyword{classif}