% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rndEffModelFitting}
\alias{rndEffModelFitting}
\title{Fit random-effects model}
\usage{
rndEffModelFitting(
  theta_0,
  V,
  M,
  M_bdiag,
  y,
  VCNs,
  nObs,
  maxit,
  maxemit,
  eps = 1e-05,
  thetaLB,
  thetaUB,
  factr,
  pgtol,
  lmm,
  trace = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{theta_0}{p-dimensional vector parameter used as initial guess in the inference procedure.}

\item{V}{A \eqn{p \times K}{p by K} dimensional net-effect matrix.}

\item{M}{A \eqn{n \times K}{n by K} dimensional (design) matrix.}

\item{M_bdiag}{A\eqn{n \times Jp}{n by J*p} dimensional block-diagonal design matrix.
Each j-th block (\eqn{j = 1,\dots,J}{j = 1,..,J}) is a \eqn{n_j \times p}{n_j by p} dimensional design matrix for the j-th clone.}

\item{y}{n-dimensional vector of the time-adjacent cellular increments}

\item{VCNs}{A n-dimensional vector including values of the vector copy number corresponding to the cell counts of y.}

\item{nObs}{A K-dimensional vector including the frequencies of each clone k (\eqn{k = 1,\dots,K}{k = 1,..,K}).}

\item{maxit}{maximum number of iterations for the optimization step.
This argument is passed to optim() function. Details on "maxit" can be found in "optim()" documentation page.}

\item{maxemit}{maximum number of iterations for the expectation-maximization algorithm.}

\item{eps}{relative error for the value x and the objective function f(x) that has to be optimized
in the expectation-maximization algorithm.}

\item{thetaLB}{p-dimensional vector of lower bound values for theta.}

\item{thetaUB}{p-dimensional vector of upper bound values for theta.}

\item{factr}{controls the convergence of the "L-BFGS-B" method.
Convergence occurs when the reduction in the objective is within this factor of the machine tolerance.
Default is 1e7, that is a tolerance of about 1e-8.
This argument is passed to optim() function.}

\item{pgtol}{helps control the convergence of the "L-BFGS-B" method.
It is a tolerance on the projected gradient in the current search direction.
This defaults to zero, when the check is suppressed.
This argument is passed to optim() function.}

\item{lmm}{is an integer giving the number of BFGS updates retained in the "L-BFGS-B" method, It defaults to 5.
This argument is passed to optim() function.}

\item{trace}{Non-negative integer. If positive, tracing information on the progress of the optimization is produced.
This parameter is passed to the optim() function.
Higher values may produce more tracing information: for method "L-BFGS-B" there are six levels of tracing.
(To understand exactly what these do see the source code: higher levels give more detail.)}

\item{verbose}{(defaults to TRUE) Logical value. If TRUE, then information messages on the progress of the
algorithm are printed to the console.}
}
\value{
The output returned by "optim()" function (see "optim()" documentation for details) along with
the conditional expectation \eqn{E[u \vert y]}{E[u|y]} and variance \eqn{V[u \vert y]}{V[u|y]}
of the latent states u given the observed states y from the last step of the expectation-maximization algorithm.
}
\description{
Fit the random-effects model to the given data using an expectation-maximization algorithm.
}
\keyword{internal}
