% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.rlgtfit.R
\name{forecast.rlgtfit}
\alias{forecast.rlgtfit}
\title{Rlgt forecast}
\usage{
\method{forecast}{rlgtfit}(
  object,
  xreg = NULL,
  h = ifelse(frequency(object$x) > 1, 2 * frequency(object$x), 10),
  level = c(80, 95),
  NUM_OF_TRIALS = 2000,
  ...
)
}
\arguments{
\item{object}{rlgtfit object}

\item{xreg}{input regression matrix}

\item{h}{forecasting horizon (the default is 10 for annual and 2*periods otherwise)}

\item{level}{confidence levels for prediction intervals a.k.a. coverage percentiles. Musat be between 0 and 100.}

\item{NUM_OF_TRIALS}{number of simulations to run. Suggested range is between (1000,5000), but it needs 
to be higher for good coverage for very high levels, e.g. 99.8.}

\item{...}{currently not used}
}
\value{
returns a forecast object compatible with the forecast package in R
}
\description{
produce forecasts from an \code{\link{rlgtfit}} object
}
\examples{
# The following is a toy example that runs within a few seconds. To get good 
# fitting results the number of iterations should be set to at least 2000, and 
# 4 chains should be used (the default). To speed up computation the number of 
# cores should also be adjusted (default is 4).

rlgt_model <- rlgt(lynx, method = "Stan",
       control=rlgt.control(MAX_NUM_OF_REPEATS=1, NUM_OF_ITER=50, NUM_OF_CHAINS = 1, 
                            NUM_OF_CORES = 1), verbose=TRUE)

# print the model details
print(rlgt_model)

# Produce Forecasts for the next 10 years
forecast_result <- forecast(rlgt_model, h = 10, level=c(80, 95, 98))

plot(forecast_result,main="Forecasting lynx dataset with LGT model")

}
