% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_fn.R
\name{cov_GHBMP}
\alias{cov_GHBMP}
\title{Covariance of Gaussian Haar-based multifractional processes}
\usage{
cov_GHBMP(
  t,
  H,
  J = 8,
  theta = NULL,
  plot = FALSE,
  num.cores = availableCores(omit = 1)
)
}
\arguments{
\item{t}{Time point or time sequence on the interval \eqn{[0,1]}.}

\item{H}{Hurst function \eqn{H(t)} which depends on \code{t}.}

\item{J}{Positive integer. For large J values could be rather time consuming. Default is set to 8.}

\item{theta}{Optional: Smoothing parameter.}

\item{plot}{Logical: If TRUE, a 3D surface plot of the covariance function is plotted in interactive sessions.}

\item{num.cores}{Number of cores to set up the clusters for parallel computing.}
}
\value{
An \eqn{m \times m} matrix, where \eqn{m} is the length of \code{t}.
}
\description{
Computes the theoretical covariance matrix of a Gaussian Haar-based multifractional process.
}
\details{
To make it comparable with the empirical covariance function the same smoothing parameter
\code{theta} can be used if needed.
}
\examples{
\donttest{
t <- seq(0, 1, by = 0.01)
H <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}

#Smoothed covariance function
cov_GHBMP(t, H, theta = 0.1, plot = TRUE)

#Non-smoothed covariance function
cov_GHBMP(t, H, plot = TRUE)
}
}
\references{
Ayache, A., Olenko, A. and Samarakoon, N. (2025).
On Construction, Properties and Simulation of Haar-Based Multifractional Processes. \doi{doi:10.48550/arXiv.2503.07286}. (submitted).
}
\seealso{
\code{\link{GHBMP}}, \code{\link{est_cov}}
}
