% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_effect.R
\name{treatment_effect}
\alias{treatment_effect}
\alias{difference}
\alias{risk_ratio}
\alias{odds_ratio}
\title{Treatment Effect}
\usage{
treatment_effect(object, pair, eff_measure, eff_jacobian, alpha, ...)

difference(object, ...)

risk_ratio(object, ...)

odds_ratio(object, ...)
}
\arguments{
\item{object}{Object from which to obtain treatment effect. Must be obtained from \code{estimate_effect()}.}

\item{pair}{(\code{integer} or \code{character}) Names or index of the treatment levels.}

\item{eff_measure}{(\code{function}) Treatment effect measurement function.}

\item{eff_jacobian}{(\code{function}) Treatment effect jacobian function.}

\item{alpha}{Nominal level}

\item{...}{Additional arguments passed to \code{glm}}
}
\value{
A list of \code{treatment_effect} object with following elements:
\itemize{
\item \code{mm_name}: name of the treatments to compare.
\item \code{marginal_mean}: estimate of the treatment effect.
\item \code{mmvariance}: estimate of the covariance matrix.
\item \code{trt_effect}: estimate of the contrast.
\item \code{variance}: estimate of the variance of contrast.
\item \code{contrast}: name of the contrast function.
\item \code{settings}: estimation settings.
}
}
\description{
Obtain treatment effect and variance from counter-factual prediction
}
