% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ipm.R
\name{pdb_make_ipm}
\alias{pdb_make_ipm}
\title{Generate IPMs from Padrino objects}
\usage{
pdb_make_ipm(proto_ipm_list, addl_args = list())
}
\arguments{
\item{proto_ipm_list}{Output from \code{pdb_make_proto_ipm}.}

\item{addl_args}{A named list of additional arguments to pass to
\code{\link[ipmr]{make_ipm}}.}
}
\value{
A list of IPMs.
}
\description{
This function generates complete IPMs from objects created with
\code{pdb_make_proto_ipm}.
}
\details{
The format of \code{addl_args} should be a nested list. The names
of the outermost level should correspond to the \code{ipm_id} that the arguments
apply to. Each entry of the outermost level should itself then be a named list
where the names correspond to arguments to \code{\link[ipmr]{make_ipm}}, and the
values are the values for each argument. See examples.
}
\examples{
\dontrun{

data("pdb_ex")

proto <- pdb_make_proto_ipm(pdb_ex, ipm_id = "aaa341", det_stoch = "det")

ipm   <- pdb_make_ipm(proto)

proto <- pdb_make_proto_ipm(pdb_ex,
                            ipm_id     = "aaaa55",
                            det_stoch  = "stoch",
                            kern_param = "kern")

args  <-list(

 # The names in the outermost list should be ipm_id's

 aaaa55 = list(

   # The names in the inner list should be arguments to make_ipm()

   report_progress = TRUE,
   iterate         = TRUE,
   iterations      = 100,
   kernel_seq      = sample(2004:2014, 100, replace = TRUE)
 )
)

ipm   <- pdb_make_ipm(proto, addl_args = args)
}

}
