% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rsampling.R
\name{Rsampling}
\alias{Rsampling}
\title{Repeats randomizations and scores summary statistics}
\usage{
Rsampling(type = c("normal_rand", "rows_as_units", "columns_as_units",
  "within_rows", "within_columns"), dataframe, statistics, ntrials = 10000,
  simplify = TRUE, progress = "text", fix.zeroes = FALSE, ...)
}
\arguments{
\item{type}{character; the name of the randomization function to be applied to \code{dataframe}.
See \link[=basefunctions]{randomization functions}.}

\item{dataframe}{a dataframe with the data to be shuffled or resampled.}

\item{statistics}{a function that calculates the statistics of interest from the dataframe.
The first argument should be the dataframe with the data and preferably should
return a (named) vector, data frame, matrix or array.}

\item{ntrials}{integer; number of randomizations to perform.}

\item{simplify}{logical; should the result be simplified
to a vector, matrix or higher dimensional array if possible?}

\item{progress}{which kind of progress bar should be used (currently unimplemented!)}

\item{fix.zeroes}{logical; for normal_rand, within_rows or within_columns, should zeroes in the dataframe
be kept in place? See the help on \code{\link{zfsample}} for more details.}

\item{...}{further arguments to be passed to the randomization functions
(e.g., \code{cols}, \code{replace}, \code{stratum}).}
}
\value{
a list of objects returned by the function defined by \code{statistics}
or a vector, matrix or array when \code{simplify=TRUE} and simplification can be done
(see \code{\link[base]{simplify2array}}).
}
\description{
Repeats resampling/shuffling of dataframes and scores the values returned by
user-define function which is applied to each randomized dataframe.
}
\section{Details}{


This function corresponds to \emph{Repeat and score} in Resampling Stats add-in for Excel
(www.resample.com). The randomization function defined by \code{type} is applied \code{ntrials}
times on the data provided by \code{dataframe}. At each trial the function defined by argument
\code{statistics} is applied to the resulting dataframe and the resulting objects are returned.
}

\section{References}{


Statistics.com LCC. 2009. Resampling Stats Add-in for Excel User's Guide.
\url{http://www.resample.com/content/software/excel/userguide/RSXLHelp.pdf}
}

