% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAll.R
\name{buildAll}
\alias{buildAll}
\title{Automatic complete statistical model building}
\usage{
buildAll(
  project = NULL,
  final.project = NULL,
  model = "all",
  prior = NULL,
  weight = NULL,
  coef.w1 = 0.5,
  cv.min = 0.001,
  fError.min = 0.001,
  paramToUse = "all",
  covToTest = "all",
  covToTransform = "none",
  center.covariate = FALSE,
  criterion = "BICc",
  linearization = FALSE,
  ll = T,
  test = T,
  direction = NULL,
  steps = 1000,
  max.iter = 20,
  explor.iter = 2,
  seq.cov = FALSE,
  seq.corr = TRUE,
  seq.cov.iter = 0,
  p.max = 0.1,
  p.min = c(0.075, 0.05, 0.1),
  print = TRUE,
  nb.model = 1,
  fix.param1 = NULL,
  fix.param0 = NULL,
  remove = T,
  add = T,
  delta = c(30, 10, 5),
  omega.set = NULL,
  pop.set1 = NULL,
  pop.set2 = NULL
)
}
\arguments{
\item{project}{a string: the initial Monolix project}

\item{final.project}{a string: the final Monolix project (default adds "_buildAll" to the original project)}

\item{model}{components of the model to optimize c("residualError", "covariate", "correlation"), (default="all")}

\item{prior}{list of prior probabilities for each component of the model (default=NULL)}

\item{weight}{list of penalty weights for each component of the model (default=NULL)}

\item{coef.w1}{multiplicative weight coefficient used for the first iteration only (default=0.5)}

\item{cv.min}{value of the coefficient of variation below which an individual parameter is considered fixed (default=0.001)}

\item{fError.min}{minimum fraction of residual variance for combined error model (default = 1e-3)}

\item{paramToUse}{list of parameters possibly function of covariates (default="all")}

\item{covToTest}{components of the covariate model that can be modified   (default="all")}

\item{covToTransform}{list of (continuous) covariates to be log-transformed (default="none")}

\item{center.covariate}{TRUE/FALSE center the covariates of the final model (default=FALSE)}

\item{criterion}{penalization criterion to optimize c("AIC", "BIC", "BICc", gamma)}

\item{linearization}{TRUE/FALSE whether the computation of the likelihood is based on a linearization of the model (default=FALSE, deprecated)}

\item{ll}{TRUE/FALSE  compute the observe likelihood and the criterion to optimize at each iteration}

\item{test}{TRUE/FALSE  perform additional statistical tests for building the model (default=TRUE)}

\item{direction}{method for covariate search c("full", "both", "backward", "forward"), (default="full" or "both")}

\item{steps}{maximum number of iteration for stepAIC (default=1000)}

\item{max.iter}{maximum number of iterations (default=20)}

\item{explor.iter}{number of iterations during the exploratory phase (default=2)}

\item{seq.cov}{TRUE/FALSE whether the covariate model is built before the correlation model}

\item{seq.corr}{TRUE/FALSE whether the correlation model is built iteratively (default=TRUE)}

\item{seq.cov.iter}{number of iterations before building the correlation model (only when seq.cov=F, default=0)}

\item{p.max}{maximum p-value used for removing non significant relationships between covariates and individual parameters (default=0.1)}

\item{p.min}{minimum p-values used for testing the components of a new model (default=c(0.075, 0.05, 0.1))}

\item{print}{TRUE/FALSE display the results (default=TRUE)}

\item{nb.model}{number of models to display at each iteration (default=1)}

\item{fix.param1}{parameters with variability that cannot be removed (default=NULL)}

\item{fix.param0}{parameters without variability that cannot be added (default=NULL)}

\item{remove}{try to remove random effects (default=T)}

\item{add}{try to add random effects (default=T)}

\item{delta}{maximum difference in criteria for testing a new model (default=c(30,10,5))}

\item{omega.set}{settings to define how a variance varies during iterations of SAEM}

\item{pop.set1}{Monolix settings 1}

\item{pop.set2}{Monolix settings 2}
}
\value{
a new Monolix project with a new statistical model.
}
\description{
buildAll builds the complete statistical model by iteratively calling functions
 buildmlx and buildVar 
 
Penalization criterion can be either a custom penalization of the form gamma*(number of parameters),
AIC (gamma=2) or BIC (gamma=log(N)).
}
\details{
See https://monolix.lixoft.com/rsmlx/ for more details.
}
\examples{
\dontrun{
# Build the complete statistical model using the default settings
r1 <- buildAll(project="warfarinPK_project.mlxtran")

# Force parameter Tlag to be fixed (no variability) and parameter Cl to vary
r2 <- buildAll(project="warfarinPK_project.mlxtran", fix.param0="Tlag", fix.param1="Cl")

# Estimate the log-likelihood by linearization of the model (faster)
r3 <- buildAll(project="warfarinPK_project.mlxtran", linearization=T)

}

# See http://monolix.lixoft.com/rsmlx/buildmlx/ for detailed examples of use of buildmlx
# Download the demo examples here: http://monolix.lixoft.com/rsmlx/installation

}
