% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csolnp.R
\name{csolnp}
\alias{csolnp}
\title{Nonlinear optimization using augmented Lagrange method (C++ version)}
\usage{
csolnp(
  pars,
  fn,
  gr = NULL,
  eq_fn = NULL,
  eq_b = NULL,
  eq_jac = NULL,
  ineq_fn = NULL,
  ineq_lower = NULL,
  ineq_upper = NULL,
  ineq_jac = NULL,
  lower = NULL,
  upper = NULL,
  control = list(),
  use_r_version = FALSE,
  ...
)
}
\arguments{
\item{pars}{an numeric vector of decision variables (length n).}

\item{fn}{the objective function (must return a scalar).}

\item{gr}{an optional function for computing the analytic gradient of the function (must return
a vector of length n).}

\item{eq_fn}{an optional function for calculating equality constraints.}

\item{eq_b}{a vector of the equality bounds (if eq_fn provided).}

\item{eq_jac}{an optional function for computing the analytic jacobian of the equality.
function (a matrix with number of columns n and number of rows the same length as the number of equalities).}

\item{ineq_fn}{an optional function for calculating inequality constraints.}

\item{ineq_lower}{the lower bounds for the inequality (must be finite)}

\item{ineq_upper}{the upper bounds for the inequalitiy (must be finite)}

\item{ineq_jac}{an optional function for computing the analytic jacobian of the inequality (a matrix
with number of columns n and number of rows the same length as the number of inequalities).}

\item{lower}{lower bounds for the parameters. This is strictly required.}

\item{upper}{upper bounds for the parameters. This is strictly required.}

\item{control}{a list of solver control parameters (see details).}

\item{use_r_version}{(logical) used for debugging and validation. Uses the R version of the solver
rather than the C++ version. Will be deprecated in future releases.}

\item{...}{additional arguments passed to the supplied functions (common to all functions supplied).}
}
\value{
A list with the following slot:
\describe{
\item{pars}{ The parameters at the optimal solution found.}
\item{objective}{ The value of the objective at the optimal solution found.}
\item{objective_history}{ A vector of objective values obtained at each outer iteration.}
\item{out_iterations}{The number of outer iterations used to arrive at the solution.}
\item{convergence}{The convergence code (0 = converged).}
\item{message}{The convergence message.}
\item{kkt_diagnostics}{A list of optimal solution diagnostics.}
\item{lagrange}{ The vector of Lagrange multipliers at the optimal solution found.}
\item{n_eval}{ The number of function evaluations.}
\item{elapsed}{ The time taken to find a solution.}
\item{hessian}{ The Hessian at the optimal solution.}
}
}
\description{
Nonlinear optimization using augmented Lagrange method (C++ version)
}
\details{
The optimization problem solved by \code{csolnp} is formulated as:
\deqn{
\begin{aligned}
\min_{x \in \mathbb{R}^n} \quad & f(x) \\
\text{s.t.} \quad & g(x) = b \\
& h_l \le h(x) \le h_u\\
& x_l \le x \le x_u\\
\end{aligned}
}

where \eqn{f(x)} is the objective function, \eqn{g(x)} is the vector of equality constraints
with target value \eqn{b}, \eqn{h(x)} is the vector of inequality constraints bounded
by \eqn{h_l} and \eqn{h_u}, with parameter bounds \eqn{x_l} and \eqn{x_u}. Internally,
inequality constraints are converted into equality constraints using slack variables
and solved using an augmented Lagrangian approach.
This function is based on the original R code, but converted to C++, making use of
\code{Rcpp} and \code{RcppArmadillo}.
Additionally, it allows the user to pass in analytic gradient and Jacobians, else
finite differences using functions from the \code{numDeriv} package are used.

The control list consists of the following options:
\describe{
\item{rho}{Numeric. Initial penalty parameter for the augmented Lagrangian. Controls the weight given to constraint violation in the objective. Default is \code{1}.}
\item{max_iter}{Integer. Maximum number of major (outer) iterations allowed. Default is \code{400}.}
\item{min_iter}{Integer. Maximum number of minor (inner) iterations (per major iteration) for the quadratic subproblem solver. Default is \code{800}.}
\item{tol}{Numeric. Convergence tolerance for both feasibility (constraint violation) and optimality (change in objective). The algorithm terminates when changes fall below this threshold. Default is \code{1e-8}.}
\item{trace}{Integer If \code{1}, prints progress, \code{2} includes diagnostic information during optimization. Default is \code{0}.}
}

Tracing information provides the following:
\describe{
\item{Iter}{The current major iteration number.}
\item{Obj}{The value of the objective function \eqn{f(x)} at the current iterate.}
\item{||Constr||}{The norm of the current constraint violation, summarizing how well all constraints (equality and inequality) are satisfied. Typically the Euclidean or infinity norm.}
\item{RelObj}{The relative change in the objective function value compared to the previous iteration, i.e., \eqn{|f_k - f_{k-1}| / max(1, |f_{k-1}|)}.}
\item{Step}{The norm of the parameter update taken in this iteration, i.e., \eqn{||x_k - x_{k-1}||}.}
\item{Penalty}{The current value of the penalty parameter (\eqn{\rho}) in the augmented Lagrangian. This parameter is adaptively updated to balance objective minimization and constraint satisfaction.}
}
}
\author{
Alexios Galanos
}
