% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rlaplace}
\alias{rlaplace}
\title{Generates a Laplace-distributed sample}
\usage{
rlaplace(n, m = 0, a = 1)
}
\arguments{
\item{n}{(int) - the size of the sample.}

\item{m}{(numeric) - the location parameter.}

\item{a}{(numeric) - the scale parameter.}
}
\value{
a numeric vector containing a random sample with above parameters.
}
\description{
Returns a sample from a Laplace-distributed random variable.
}
\details{
The Laplace distribution is given by the two-sided exponential distribution
given by the function:
\deqn{ f(x;a,m) = \frac{1}{2a} e^{- \left| \frac{x-m}{a} \right|} }
The random sampling is done by inverse transform sampling.
}
\examples{
sample_gamma <- rlaplace(1000, 0, 1)
}
