#' Simulated river discharge of the Ardeche river at Saint Martin d'Ardeche
#'
#' A time series of simulated river discharge of the Ardeche river close
#' to its confluence with the Rhone (longitude = 4.658 \ latitude = 44.258) from
#' 1951 to 2020. Time series extracted from the HERA dataset:
#' https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95.
#' The Ardèche is Mediterranean river mostly known for tourism due
#' to its scenic gorges, but floods and droughts can impact the
#' local economy and environment.
#'
#' @docType data
#'
#' @usage data(ArdecheStMartin)
#'
#' @format Two column dataframe:
#' #' \itemize{
#' \item time (POSIXct timestamp with 6-hourly resolution)
#' \item Q (6-houry mean discharge in cubic meter per second)
#'}
#' @keywords datasets
#' @source <https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95>
"ArdecheStMartin"

#' Simulated river discharge of the Danube river at Vienna
#'
#' A time series of simulated river discharge of the Danube river in Vienna
#' (longitude = 16.64 \ latitude = 48.13) from 1951 to 2020.
#' Time series extracted from the HERA dataset:
#' https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95.
#' The Danube is the longest river in the EU and is an important waterway for
#' international trade, connecting several countries in Central and Eastern Europe.

#'
#' @docType data
#'
#' @usage data(DanubeVienna)
#'
#' @format Two column dataframe:
#' #' \itemize{
#' \item time (POSIXct timestamp with 6-hourly resolution)
#' \item Q (6-houry mean discharge in cubic meter per second)
#'}
#' @keywords datasets
#' @source <https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95>
"DanubeVienna"



#' Simulated river discharge of the Ebro river at Zaragoza
#'
#' A time series of simulated river discharge of the Ebro river at
#' Zaragoza (longitude = -0.825 \ latitude = 41.608) from
#' 1951 to 2020. Time series extracted from the HERA dataset:
#' https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95.
#' The Ebro is Spain's longest river, with low and high water levels
#' alternating throughout the year, influenced by winter snowmelt and summer
#' evaporation/human usage. The river is vital for agriculture.

#'
#' @docType data
#'
#' @usage data(EbroZaragoza)
#'
#' @format Two column dataframe:
#' #' \itemize{
#' \item time (POSIXct timestamp with 6-hourly resolution)
#' \item Q (6-houry mean discharge in cubic meter per second)
#'}
#' @keywords datasets
#' @source <https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95>
"EbroZaragoza"


#' Simulated river discharge of the Rhone river at Lyon
#'
#' A time series of simulated river discharge of the Rhone river close
#' to its confluence with the Saone (longitude = 4.891 \ latitude = 45.772) from
#' 1951 to 2020. Time series extracted from the HERA dataset:
#' https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95.
#' The Rhône is France's most powerful river,characterized by a significant
#' seasonal variation in flow rates. The Rhône River is crucial for
#' transportation, hydropower generation, and irrigation in the region.

#'
#' @docType data
#'
#' @usage data(RhoneLyon)
#'
#' @format Two column dataframe:
#' #' \itemize{
#' \item time (POSIXct timestamp with 6-hourly resolution)
#' \item Q (6-houry mean discharge in cubic meter per second)
#'}
#' @keywords datasets
#' @source <https://data.jrc.ec.europa.eu/dataset/a605a675-9444-4017-8b34-d66be5b18c95>
"RhoneLyon"
