% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsGetPOT}
\alias{tsGetPOT}
\title{tsGetPOT Function}
\usage{
tsGetPOT(
  ms,
  pcts,
  desiredEventsPerYear,
  minEventsPerYear,
  minPeakDistanceInDays,
  tail
)
}
\arguments{
\item{ms}{A matrix containing the time series data with two columns:
the first column represents the time and the second column represents the values.}

\item{pcts}{A numeric vector specifying the percentiles to be used as
thresholds for identifying peaks.}

\item{desiredEventsPerYear}{The desired number of events per year.}

\item{minEventsPerYear}{The minimum number of events per year.}

\item{minPeakDistanceInDays}{The minimum distance between two peaks in days.}

\item{tail}{The tail to be studied for POT selection, either 'high' or 'low'.}
}
\value{
A list containing the following fields:
\describe{
\item{\code{threshold}}{The threshold value used for identifying peaks}
\item{\code{thresholdError}}{The error associated with the threshold value}
\item{\code{percentile}}{The percentile value used as the threshold.}
\item{\code{peaks}}{The values of the identified peaks.}
\item{\code{stpeaks}}{The start indices of the identified peaks.}
\item{\code{endpeaks}}{The end indices of the identified peaks.}
\item{\code{ipeaks}}{The indices of the identified peaks.}
\item{\code{time}}{The time values corresponding to the identified peaks.}
\item{\code{pars}}{The parameters of the Generalized Pareto Distribution (GPD)
fitted to the peaks.}
}
}
\description{
\code{tsGetPOT} is a function that calculates the Peaks Over Threshold (POT)
for a given time series data.
}
\examples{
# Create a sample time series data
ms <- ArdecheStMartin

# Calculate the POT using the tsGetPOT function
pcts <- c(90, 95, 99)
desiredEventsPerYear <- 5
minEventsPerYear <- 2
minPeakDistanceInDays <- 10
tail <- "high"
POTdata <- tsGetPOT(ms, pcts, desiredEventsPerYear, minEventsPerYear, minPeakDistanceInDays, tail)
# Print the results
print(POTdata)

}
\seealso{
\code{\link[=tsEvaSampleData]{tsEvaSampleData()}}
}
