% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cpernet.R
\name{plot.cpernet}
\alias{plot.cpernet}
\title{Plot coefficients from a cpernet object}
\usage{
\method{plot}{cpernet}(x, xvar = c("norm", "lambda"), color = FALSE, label = FALSE, ...)
}
\arguments{
\item{x}{fitted \code{\link{cpernet}} model}

\item{xvar}{what is on the x-axis. \code{"norm"} plots against the L1-norm of
the coefficients, \code{"lambda"} against the log-lambda sequence.}

\item{color}{if \code{TRUE}, plot the curves with rainbow colors. Otherwise,
plot the curves with gray colors. Default is \code{FALSE}.}

\item{label}{if \code{TRUE}, label the curves with variable sequence numbers.
Otherwise, do not put labels. Default is \code{FALSE}.}

\item{\dots}{other graphical parameters to plot.}
}
\description{
Produces a coefficient profile plot of the coefficient paths for a fitted
cpernet object. This function is modified based on the \code{plot} method in
the \code{glmnet} package.
}
\details{
Two coefficient profile plots are produced, one for the mean
  coefficients and the other for the scale coefficients.
}
\examples{

set.seed(1)
n <- 100
p <- 400
x <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)
tau <- 0.30
pf <- abs(rnorm(p))
pf2 <- abs(rnorm(p))
w <- 2.0
lambda2 <- 1
m2 <- cpernet(y = y, x = x, w = w, tau = tau, eps = 1e-8,
              pf.mean = pf, pf.scale = pf2, intercept = TRUE,
              standardize = FALSE, lambda2 = lambda2)
plot(m2)

}
\seealso{
\code{\link{plot.cv.cpernet}}
}
\author{
Yuwen Gu and Hui Zou\cr

  Maintainer: Yuwen Gu <yuwen.gu@uconn.edu>
}
\keyword{models}
\keyword{regression}
