% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.ernet.R
\name{plot.cv.ernet}
\alias{plot.cv.ernet}
\title{Plot the cross-validated curve produced by cv.ernet}
\usage{
\method{plot}{cv.ernet}(x, sign.lambda = 1, ...)
}
\arguments{
\item{x}{fitted \code{\link{cv.ernet}} object}

\item{sign.lambda}{either plot against \code{log(lambda)} (default) or its
negative if \code{sign.lambda=-1}.}

\item{\dots}{other graphical parameters to plot}
}
\description{
Plots the cross-validated curve, and upper and lower standard deviation
curves, as a function of the \code{lambda} values used. This function is
modified based on the \code{plot.cv.glmnet} function from the \code{glmnet}
package.
}
\details{
A plot is produced.
}
\examples{

set.seed(1)
n <- 100
p <- 400
x <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)
tau <- 0.90
pf <- abs(rnorm(p))
pf2 <- abs(rnorm(p))
lambda2 <- 1
m1.cv <- cv.ernet(y = y, x = x, tau = tau, eps = 1e-8, pf = pf,
                  pf2 = pf2, standardize = FALSE, intercept = FALSE,
                  lambda2 = lambda2)
plot(m1.cv)

}
\seealso{
\code{\link{plot.ernet}}
}
\author{
Yuwen Gu and Hui Zou\cr

  Maintainer: Yuwen Gu <yuwen.gu@uconn.edu>
}
\keyword{models}
\keyword{regression}
