% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game_data.R
\name{get_ladder_data}
\alias{get_ladder_data}
\title{Ladder Data}
\usage{
get_ladder_data(ladder_id, host_region = "us")
}
\arguments{
\item{ladder_id}{A unique identifier for a particular ladder. With the exception of grandmaster, leagues
(bronze, silver, etc.), are separated into tiers (1,2,3) which are further separated into divisions.
These divisions, or ladders, each have a unique identifier.}

\item{host_region}{The host region that the API call will be sent to. For \code{get_ladder_data}, the host
region MUST be the region that the ladder is a part of. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides data of players in a particular ladder. This includes MMR, points,
win/loss record, time of joining, time of a player's last game, and more.
}
\note{
For \code{get_ladder_data}, the host region MUST be the region that the ladder is a part of.
}
\examples{
\donttest{
### Obtain battle tags and MMR of players in a particular ladder.

#Get full ladder data
try({
    data <- get_ladder_data(ladder_id = 289444, host_region = "us")

    # Player ratings
    ratings <- data$team$rating

    # Get battle tags using list indexing with sapply
    tags <- sapply(data$team$member, function(x) x$character_link$battle_tag)
})
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API       #'          Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other game data API calls: 
\code{\link{get_league_data}()},
\code{\link{get_season_data}()}
}
\concept{game data API calls}
