% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{get_legacy_profile}
\alias{get_legacy_profile}
\title{Legacy API - Profile Data}
\usage{
get_legacy_profile(region_id, realm_id, profile_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{realm_id}{A numeric argument indicating the realm of the profile. A realm is a subset
of the region.
 \itemize{
     \item{US Region}
         \itemize{
             \item{1 = US}
             \item{2 = LatAm}
         }
     \item{EU Region}
         \itemize{
             \item{1 = Europe}
             \item{2 = Russia}
     }
     \item{KR/TW Region}
         \itemize{
             \item{1 = Korea}
             \item{2 = Taiwan}
     }
 }}

\item{profile_id}{A unique, numeric identifier for an individual's profile.}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides summary data for an individual's profile such as campaign completion, career
ladder finishes, earned achievements, and much more.
}
\note{
Legacy API call. It is recommended to use \code{\link{get_profile}} instead.
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
\code{\link{get_profile}}

Other legacy API calls: 
\code{\link{get_legacy_achievements}()},
\code{\link{get_legacy_ladders}()},
\code{\link{get_legacy_ladder}()},
\code{\link{get_legacy_match_history}()},
\code{\link{get_legacy_rewards}()}
}
\concept{legacy API calls}
