% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distplotsimple.R
\name{distplotsimple}
\alias{distplotsimple}
\title{displotsimple}
\usage{
distplotsimple(
  T2,
  SPE,
  lim.t2,
  lim.spe,
  ncomp,
  obstag = matrix(0, length(T2), 1),
  alpha = 0.05,
  plottitle = "Distance plot\\n"
)
}
\arguments{
\item{T2}{Vector with the Hotelling's T^2 values for each observation.}

\item{SPE}{Vector with the SPE values for each observation.}

\item{lim.t2}{Value of the Upper Control Limit for the T^2 statistic.}

\item{lim.spe}{Value of the Upper Control Limit for the SPE.}

\item{ncomp}{An integer indicating the number of PCs.}

\item{obstag}{Optional column vector of integers indicating the group of each
observation (\code{0} or \code{1}). Default value set to \code{matrix(0, nrow(X), 1)}.}

\item{alpha}{Optional number between 0 and 1 expressing the type I risk assumed in the
computation of the Upper Control Limits (UCL) set to \code{0.05} (5 \%) by default.}

\item{plottitle}{Optional string with the plot title, \code{"Distance plot"} by
default.}
}
\value{
distplotobj ggplot object with the generated distance plot.
}
\description{
Returns the distance plot directly providing the coordinates and Upper Control Limits.
}
\details{
Coordinates are expressed in terms of the Hotelling's T^2 (T^2, x-axis) and the Squared
Prediction Error (SPE, y-axis). Observations can be identified by the obstag input argument.
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X[1:40,], 2, 0.05, "cent") # PCA-MB with first 40 
# observations
pcaproj <- pcame(X[-c(1:40),], pcamodel.ref) # Project last observations
distplotsimple(pcaproj$T2, pcaproj$SPE, pcamodel.ref$limt2, pcamodel.ref$limspe,
pcamodel.ref$ncomp)

pcaproj <- pcame(X, pcamodel.ref) # Project all observations
tags <- dotag(X[1:40,], X[-c(1:40),]) # 0's for observations used in PCA-MB
distplotsimple(pcaproj$T2, pcaproj$SPE, pcamodel.ref$limt2, pcamodel.ref$limspe, 
pcamodel.ref$ncomp, obstag = tags)
}
