% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speinfo.R
\name{speinfo}
\alias{speinfo}
\title{speinfo}
\usage{
speinfo(SPE, E, limspe, iobs = NA)
}
\arguments{
\item{SPE}{Vector with values of the SPE statistic.}

\item{E}{Matrix with the contributions of each variable (columns) for each observation (rows)
to the SPE. It is the error term obtained from the unexplained part of X by the PCA model.}

\item{limspe}{Upper Control Limit (UCL) for the SPE, at a certain confidence level
(1-alpha)*100 \%.}

\item{iobs}{Integer with the index of the observation of interest. Default value set to
\code{NA}.}
}
\value{
ggplot object with the generated bar plots.
}
\description{
Information about the Squared Prediction Error (SPE) of an observation. Two subplots show the
information of an observation regarding its SPE statistic, i.e.: a bar plot indicating the
value of the statistic for the observation, and a bar plot with the contribution that each
variable had for the SPE value
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X[1:40,], 2, 0.05, "cent") # PCA-MB with first 40 observations
pcaproj <- pcame(X[-c(1:40),], pcamodel.ref) # Project last observations
speinfo(pcaproj$SPE, pcaproj$E, pcamodel.ref$limspe, 2) # Information about the SPE of the 
# row #2
}
