% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{emppmf}
\alias{emppmf}
\title{Empirical mass function}
\usage{
emppmf(y, weight)
}
\arguments{
\item{y}{Numerical variable}

\item{weight}{Associated weights of the variable of interest, default weight is rep(1,length(y))}
}
\value{
vals: the distinct values of \emph{y}

epmf: empirical probability mass function corresponding to each 
\emph{y} in vals
}
\description{
Calculates the empirical probability mass function for a variable with associated weights.
}
\examples{
emppmf(seq(1:10))
emppmf(htsrs$height, rep(2000/200,200))
}
