% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_sdg.R
\name{summarize_sdg}
\alias{summarize_sdg}
\title{Summarize results from SDGdetector at either the Goal level or Target level.}
\usage{
summarize_sdg(data, sum_by = "target", quiet = FALSE)
}
\arguments{
\item{data}{Data frame or a string}

\item{sum_by}{The group level to be chosen for data summary. Default parameter is
"target", and can also set at "goal" level.}

\item{quiet}{Logical. Suppress info message}
}
\value{
Data frame with at least one column named "SDG" or "Target", and one column \code{Freq} that
represent the total hits.
}
\description{
Summarize results from SDGdetector at either the Goal level or Target level.
}
\examples{
library(SDGdetector)
df <- data.frame(col = c(
    'our goal is to end poverty globally',
    'this product contributes to slowing down climate change'))
data <- SDGdetector(x = df, col = col)
summarize_sdg(data, sum_by = 'target', quiet = FALSE)

}
