#' Learning Motivation Data
#'
#' A dataset containing the aggregate learning motivation scores for the
#' subscales of intrinsic regulation, identified regulation, introjected
#' regulation, and external regulation of a total number of \eqn{1,150} students.
#'
#' The variables \code{intrinsic}, \code{identified}, \code{introjected}, and
#' \code{external} of the data frame \code{learning_motivation} contain
#' aggregate subscale scores in the sense that the scores are the means taken
#' over all raw-data test items that make up a respective subscale.
#'
#' @format A data frame with \eqn{1,150} rows and \eqn{6} variables:
#' \describe{
#'   \item{\code{sex}}{integer vector, female (\eqn{= 1}) and male (\eqn{= 2})}
#'   \item{\code{age}}{integer vector, years}
#'   \item{\code{intrinsic}}{numeric vector, aggregate intrinsic regulation subscale
#'     motivation scores}
#'   \item{\code{identified}}{numeric vector, aggregate identified regulation subscale
#'     motivation scores}
#'   \item{\code{introjected}}{numeric vector, aggregate introjected regulation
#'     subscale motivation scores}
#'   \item{\code{external}}{numeric vector, aggregate external regulation subscale
#'     motivation scores}
#' }
#' @source
#' Mueller, F. H. and Hanfstingl, B. and Andreitz, I. (2007) Skalen zur
#' motivationalen Regulation beim Lernen von Schuelerinnen und Schuelern:
#' adaptierte und ergaenzte Version des Academic Self-Regulation Questionnaire
#' (SRQ-A) nach Ryan & Connell [Scales of motivational regulation for student
#' learning: adapted and supplemented version of the Academic Self-Regulation
#' Questionnaire (SRQ-A) by Ryan & Connell] (Transl. A. Uenlue). In Institut
#' fuer Unterrichts- und Schulentwicklung (Ed.), \emph{Wissenschaftliche
#' Beitraege} [\emph{Scientific Contributions}] (Transl. A. Uenlue) (pp. 1--17).
#' Klagenfurt, Austria: Alpen-Adria-Universitaet.
#' @seealso The three main functions of the package:
#' \code{\link{internalization}} for motivation internalization analysis of the
#' data; \code{\link{sdi}} for the orginal and adjusted SDI or RAI index of the
#' data; and \code{\link{simplex}} for motivation simplex structure analysis of
#' the data. See also \code{\link{SDT-package}} for general information about
#' this package.
"learning_motivation"
