#' Survey of Parents of Children Non-Immunized against Measles  
#'
#' Roberts et al. (1995) report on the results of a survey of parents whose
#' children had not been immunized against measles during a recent campaign
#' to immunize all children in the first five years of secondary school.
#' @name measles
#' @docType data
#' @format Data frame with 11 variables. A parent who refused consent 
#' (variable 4) was asked why, with responses in variables 5-10.
#' A parent could give more than one reason for not having the child
#' immunized. 
#' \describe{
#'   \item{school}{school attended by child}
#'   \item{form}{parent received consent form}
#'   \item{returnf}{parent returned consent form}
#'   \item{consent}{parent gave consent for measles immunization}
#'   \item{hadmeas}{child had already had measles}
#'   \item{previmm}{child had been immunized against measles}
#'   \item{sideeff}{parent concerned about side effects}
#'   \item{gp}{parent wanted GP (general practitioner) to give vaccine}
#'   \item{noshot}{child did not want injection}
#'   \item{notser}{parent thought measles not serious illness}
#'   \item{gpadv}{GP advised that vaccine was not needed}
#' }
#' @note The original data were unavailable; univariate and multivariate summary
#' statistics from these artificial data, however, are consistent with those
#' in the paper. 
#' @source Roberts R. J. et al. (1995). Reasons for non-uptake of measles, mumps, and
#' rubella catch up immunisation in a measles epidemic and side effects of the
#' vaccine, \emph{British Medical Journal}, 310, 1629--1632.
#' @references Lohr (1999). Sampling: Design and Analysis, Duxbury, p. TODO and
#'   442. 
"measles"