% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov2_2015WL.R
\name{cov2.2015WL}
\alias{cov2.2015WL}
\title{Two-sample Test for Covariance Matrices by Wu and Li (2015)}
\usage{
cov2.2015WL(X, Y, m = 50)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{m}{the number of random projections to be applied.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \Sigma_x = \Sigma_y\quad vs\quad H_1 : \Sigma_x \neq \Sigma_y}
using the procedure by Wu and Li (2015).
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
smallY = matrix(rnorm(10*3),ncol=3)
cov2.2015WL(smallX, smallY) # run the test

\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(50*5), ncol=10)
  Y = matrix(rnorm(50*5), ncol=10)
  
  counter[i] = ifelse(cov2.2015WL(X, Y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'cov2.2015WL'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{wu_tests_2015}{SHT}
}
\concept{covariance}
