% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs.gene.trans.R
\name{bs.gene.trans}
\alias{bs.gene.trans}
\title{Generate Mapping Basis}
\usage{
bs.gene.trans(
  type,
  mp_type,
  k,
  upper = 10,
  s = 1,
  n_esti = 500,
  c = 10,
  or = 4
)
}
\arguments{
\item{type}{type indicates which type of basis is used}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{k}{k-th basis function}

\item{upper}{the upper bound for basis domain, the default is 10}

\item{s}{s is a positive scaling factor, the default is 1}

\item{n_esti}{the number of values got from k-th basis function, the default is 500}

\item{c}{c only used in Cspli which indicates the total number of knots to generate, the default is 10, c should not be less than k.(for splines, the true
number of basis is c-2+or)}

\item{or}{indicates the order of spline and only used in Cspli type, default is 4 which indicates cubic spline}
}
\value{
A matrix in which the k-th column corresponds to the values of the k-th mapped basis function
}
\description{
this function generates the value of k-th basis function. (The wavelet basis options return the full table)
}
\examples{
bs.gene.trans("Legen", "algeb", 5)
}
\references{
[1] Chen, Xiaohong. “Large Sample Sieve Estimation of Semi-Nonparametric Models.” Handbook of Econometrics, 6(B): 5549–5632,2007.
}
