% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.SCR.R
\name{fix.SCR}
\alias{fix.SCR}
\title{User-specified creation of a Simultaneous Confidence Region (SCR) for the estimated function}
\usage{
fix.SCR(
  ts,
  c,
  d,
  m = "MV",
  b_time,
  b_timese,
  mp_type,
  type,
  fix_num = 0,
  r = 1,
  s = 1,
  n_point = 4000,
  upper = 10
)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{the maximum value of number of basis for time input}

\item{d}{the maximum value of number of basis for variate input}

\item{m}{the window size for the simultaneous confidence region procedure, with the default being 'MV,' which stands for the Minimum Volatility method}

\item{b_time}{type of basis for time input}

\item{b_timese}{type of basis for variate input}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{type}{select type of estimation."fixt" indicates fixed time t value. "fixx" represents fix variate value}

\item{fix_num}{fix_num indicates the use of fixed-value nonlinear time series regression. If "fixt" is chosen, it represents a fixed time value. Otherwise,
if not selected, it pertains to a fixed variate value}

\item{r}{indicates number of variate}

\item{s}{s is a positive scaling factor, the default is 1}

\item{n_point}{number of points for SCR, the default is 4000}

\item{upper}{upper The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -upper to upper}
}
\value{
A list containing dataframes with three columns each. The first column corresponds to input values. The second column contains values of the estimated function, along with
their upper and lower bounds. The third column is a factor that indicates the types associated with the values in the second column.
}
\description{
This function generates a Simultaneous Confidence Region (SCR) for the estimated function
}
