% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIMplyBee.R
\docType{package}
\name{SIMplyBee-package}
\alias{SIMplyBee}
\alias{SIMplyBee-package}
\title{SIMplyBee: 'AlphaSimR' Extension for Simulating Honeybee Populations and Breeding Programmes}
\description{
SIMplyBee is an extension of the AlphaSimR package
(https://cran.r-project.org/package=AlphaSimR) for stochastic simulations of
honeybee populations and breeding programmes. It enables simulation of
individual bees that form a colony, which includes a queen, fathers (drones
the queen mated with), virgin queens, workers, and drones. Multiple colony can
be merged into a population of colonies, such as an apiary or a whole country
of colonies. Functions enable operations on castes, colony, or colonies, to
ease R scripting of whole populations. All AlphaSimR functionality with
respect to genomes and genetic and phenotype values is available and further
extended for honeybees, including haplo-diploidy, csd locus, colony events
(swarming, supersedure, etc.), and colony phenotype values.

See the introductory vignette on using this package by running:
\code{vignette("Honeybee_biology", package="SIMplyBee")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/HighlanderLab/SIMplyBee}
}

}
\author{
\strong{Maintainer}: Jana Obšteter \email{obsteter.jana@gmail.com} (\href{https://orcid.org/0000-0003-1511-3916}{ORCID})

Authors:
\itemize{
  \item Laura Strachan (\href{https://orcid.org/0000-0002-2569-0250}{ORCID})
  \item Jernej Bubnič (\href{https://orcid.org/0000-0003-1362-3736}{ORCID})
  \item Gregor Gorjanc (\href{https://orcid.org/0000-0001-8008-2787}{ORCID})
}

}
\keyword{internal}
