% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluskur.R
\name{ClusKur}
\alias{ClusKur}
\title{Cluster Identification Procedure using Projections on Directions of Extreme Kurtosis Coefficient}
\usage{
ClusKur(x)
}
\arguments{
\item{x}{p by k data matrix: p features or variables for each time series
and k time series in columns.}
}
\value{
A list containing:
\itemize{
\item lbl - Cluster labels (possible outliers get negative labels).
\item ncl - Number of clusters.
}
}
\description{
Identification of groups using projections of a vector of features of each time series
in directions of extreme kurtosis coefficient.
}
\examples{
data(Stockindexes99world)
S <- Stockindexes99world[,-1]
v1 <- apply(S,2, mean)
v2 <- apply(S,2, sd)
M <- rbind(v1,v2)
out <- ClusKur(M)

}
