% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnivariateCalibratePerformanceMeasure.R
\name{calibrateControlLimit}
\alias{calibrateControlLimit}
\title{Calibration of the control limit for the selected chart}
\usage{
calibrateControlLimit(
  targetARL = NULL,
  targetMRL = NULL,
  n,
  m,
  theta = NULL,
  Ftheta = NULL,
  scoring = "Z",
  Chi2corrector = "None",
  dist,
  mu,
  sigma,
  dist.par = c(0, 1, 1),
  chart,
  chart.par,
  replicates = 50000,
  isParallel = TRUE,
  maxIter = 20,
  progress = TRUE,
  alignment = "unadjusted",
  constant = NULL,
  absolute = FALSE,
  isFixed = FALSE,
  rounding.factor = NULL
)
}
\arguments{
\item{targetARL}{scalar. is the target ARL to calibrate. By default is set to NULL}

\item{targetMRL}{scalar. is the target ARL to calibrate. By default is set to NULL}

\item{n}{scalar. Subroup size}

\item{m}{scalar. Reference sample size}

\item{theta}{scalar. Value corresponig with the \code{Ftheta} quantile.}

\item{Ftheta}{scalar. Quantile of the data distribution. The values that take are between (0,1).}

\item{scoring}{character string. If "Z" (normal scores) (default). If "Z-SQ" (normal scores squared).}

\item{Chi2corrector}{character string. Only when scoring is Z-SQ. Select from
\itemize{
  \item{"approx: Z^2*(m + 1 + 1.3)/(m+1).}
  \item{"exact": Z^2/mean(Z).}
  \item{"none": Z^2.}
}
If "approx" () (default). If "exact" (normal scores squared).}

\item{dist}{character string. Select from:
\itemize{
  \item{"Uniform: Continuous Uniform distribution .}
  \item{"Normal": Normal distribution (default).}
  \item{"Normal2": Squared Normal distribution (also known as Chi-squared).}
  \item{"DoubleExp": Double exponential distribution (also known as Laplace distribution).}
  \item{"DoubleExp2": Double exponential squared distribution from a \code{DoubleExp(0,1)}.}
  \item{"LogNormal": Lognormal distribution.}
  \item{"Gamma": Gamma distribution.}
  \item{"Weibull": Weibull distribution.}
  \item{"t": Student-t distribution.}
}}

\item{mu}{vector. Two elements, the first one is the mean of the reference sample and the second one is the mean of the monitoring sample.}

\item{sigma}{vector. Two elements, the first one is the sd of the reference sample and the second one is the sd of the monitoring sample.}

\item{dist.par}{vector. Distribution parameters. \code{c(par.a, par.b)}. Default \code{c(0,1)}.}

\item{chart}{character string. Selected type of chart. Three options are available: Shewhart, CUSUM, EWMA}

\item{chart.par}{vector. The size depends on the selected chart:
\describe{
  \item{Shewhart scheme: }{is \code{c(k)}, where \code{k} comes from \eqn{UCL = mu + k\sigma, LCL = mu - k\sigma.}}
  \item{CUSUM scheme: }{is \code{c(k, h, t)} where \code{k} is the reference value and \code{h} is the control limit,
  and \code{t} is the type of the chart (1:positive, 2:negative, 3:two sides)}
  \item{EWMA scheme: }{is \code{c(lambda, L)}, where \code{lambda} is the smoothing constant
  and \code{L} multiplies standard deviation to get the control limit}
}}

\item{replicates}{scalar. Number of replicates to get the ARL}

\item{isParallel}{logical. If \code{TRUE} the code runs in parallel according to the
number of cores in the computer,otherwise the code runs sequentially. Default \code{TRUE}.}

\item{maxIter}{scalar. is a numeric. The maximum number of iteration to take the calibration before stops}

\item{progress}{logical. If \code{TRUE} it shows the progress in the console.}

\item{alignment}{character string. Aligment of the data \code{X} and \code{Y}. Select from
\itemize{
  \item "unadjusted": nothing is sustracte from \code{X} and \code{Y} (default).
  \item "overallmean": overall mean is sustracted from \code{X} and \code{Y}.
  \item "overallmedian": overall median is sustracted from \code{X} and \code{Y}.
  \item "samplemean": mean from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "samplemedian": median from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "referencemean": mean from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "referencemedian": median from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "constantvalue": a constant value is subtracted from \code{X} and \code{Y}.
}}

\item{constant}{scalar. Only used when the \code{alignment} is selected "constantvalue". Default \code{NULL}.}

\item{absolute}{logical. If \code{TRUE}, the absolute aligned values are obtained. (Default \code{FALSE})}

\item{isFixed}{logical. If \code{TRUE} the reference sample does not update, otherwise the reference sample is updated whenever the batch is in control.}

\item{rounding.factor}{scalar. positive value that determine the range between two consecutive rounded values.}
}
\value{
Multiple output. Select by \code{output$}
\itemize{
  \item \code{objective.function}: scalar. The best solution obtained, in terms of the target ARL or MRL
  \item \code{par.value}: scalar. Which parameter of the chart reach this best solution
  \item \code{iter}: scalar. In which iteration is found the objective function.
  \item \code{found}: boolean. Is TRUE if in the \code{maxIter} is reached the desired +-5% of target ARL, or MRL.
}
}
\description{
The methodology used to calibrate the control limit
for the SNS chart depending on the selected chart
}
\note{
The argument \code{chart.par} in this function correspond to the initial parameters to start the calibration.
}
\examples{
n <- 2 # subgroup size
m <- 30 # reference-sample size
dist <- "Normal" # distribution
mu <- c(0, 0) # c(reference sample mean, monitoring sample mean)
sigma <- c(1, 1) # c(reference sample sd, monitoring sample sd)

#### Distribution parameters
dist.par <- c(0, 1) # c(location, scale)

#### Other Parameters
replicates <- 2
targetARL <- 370
isParallel = FALSE

#### Control chart parameters
chart <- "Shewhart"
chart.par <- c(3)
shewhart <- calibrateControlLimit(
  targetARL = targetARL, targetMRL = NULL, n = n, m = m, theta = NULL,
  Ftheta = NULL, dist = dist, mu = mu, sigma = sigma, dist.par = dist.par, chart.par = chart.par,
  replicates = replicates, chart = chart, isParallel = isParallel
)

chart <- "CUSUM"
chart.par <- c(0.5, 2.5, 3)
cusum <- calibrateControlLimit(
  targetARL = targetARL, targetMRL = NULL, n = n, m = m, theta = NULL,
  Ftheta = NULL, dist = dist, mu = mu, sigma = sigma, dist.par = dist.par, chart.par = chart.par,
  replicates = replicates, chart = chart, isParallel = isParallel
)

chart <- "EWMA"
chart.par <- c(0.2, 2.962)
ewma <- calibrateControlLimit(
  targetARL = targetARL, targetMRL = NULL, n = n, m = m, theta = NULL,
  Ftheta = NULL, dist = dist, mu = mu, sigma = sigma, dist.par = dist.par, chart.par = chart.par,
  replicates = replicates, chart = chart, isParallel = isParallel
)
}
