% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateNormalScores.R
\name{MNS}
\alias{MNS}
\title{Multivariate Normal Scores}
\usage{
MNS(
  X,
  Y = NULL,
  theta = NULL,
  Ftheta = NULL,
  scoring = "Z",
  alignment = "unadjusted",
  constant = NULL,
  absolute = FALSE
)
}
\arguments{
\item{X}{matrix or data.frame. New observations to obtain the normal scores.}

\item{Y}{matrix or data.frame. If \code{Y} is not defined (no previous observation available, \code{NULL}), NS is relative to \code{X}. Default \code{NULL}.}

\item{theta}{vector. Value corresponding with the \code{Ftheta} quantile.}

\item{Ftheta}{vector. Quantile of the data distribution. The values that take are between (0,1).}

\item{scoring}{character string. If "Z" (normal scores) (default). If "Z-SQ" (normal scores squared).}

\item{alignment}{character string. Aligment of the data \code{X} and \code{Y}. Select from
\itemize{
  \item "unadjusted": nothing is sustracte from \code{X} and \code{Y} (default).
  \item "overallmean": overall mean is sustracted from \code{X} and \code{Y}.
  \item "overallmedian": overall median is sustracted from \code{X} and \code{Y}.
  \item "samplemean": mean from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "samplemedian": median from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "referencemean": mean from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "referencemedian": median from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "constantvalue": a constant value is subtracted from \code{X} and \code{Y}.
}}

\item{constant}{scalar. Only used when the \code{alignment} is selected "constantvalue". Default \code{NULL}.}

\item{absolute}{logical. If \code{TRUE}, the absolute aligned values are obtained. (Default \code{FALSE})}
}
\value{
Multiple output. Select by \code{output$}
\itemize{
  \item \code{R}: matrix. Multivariate Ranks for the \code{X} observations. If ties occurs, average ranks are used.
  \item \code{P}: matrix. Multivariate Probability of the ranks for the \code{X} observations. Instead of Van Der Waerden normal scores where \eqn{P = R/(n+1)}, \eqn{P = (R-0.5)/n},
where \eqn{R} stands for rank and \eqn{P} for the input evaluated in the inverse of a Standard Normal Distribution.
  \item \code{Z}: matrix. Multivariate Normal scores for the \code{X} observations. \eqn{Z} if \code{scoring} is "Z" and \eqn{Z^2} if \code{scoring} is "Z-SQ".
}
}
\description{
Get conditional or unconditional multivariate normal score (NS) of observations (\code{X})
relative to previous observations (\code{Y}).
}
\examples{
Y <- c(10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100)
Y = matrix(Y, ncol=2)
X <- c(30, 35, 45, 30, 35, 45)
X = matrix(X, ncol=2)
theta <- c(40, 40)
Ftheta <- c(0.5, 0.5)
# EXAMPLE CONDITIONAL
MNS(X = X, Y = Y, theta = theta, Ftheta = Ftheta)
}
