% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateObtainAverageRunLength.R
\name{mgetARL}
\alias{mgetARL}
\title{Multivariate Average Run Length (ARL)}
\usage{
mgetARL(
  n,
  m,
  nv,
  theta = NULL,
  Ftheta = NULL,
  dists,
  dists.par = NULL,
  mu,
  sigma = NULL,
  chart = "T2",
  chart.par = c(0.005),
  correlation = 0,
  s = NULL,
  replicates = 10000,
  isParallel = TRUE,
  print.RL = FALSE,
  progress = FALSE,
  calibrate = FALSE,
  arl0 = 370,
  alignment = "unadjusted",
  constant = NULL,
  absolute = FALSE
)
}
\arguments{
\item{n}{scalar. Subroup size}

\item{m}{scalar. Reference sample size}

\item{nv}{scalar. Number of variables to be generated.}

\item{theta}{vector. Value corresponding with the \code{Ftheta} quantile.}

\item{Ftheta}{vector. Quantile of the data distribution. The values that take are between (0,1).}

\item{dists}{list.  Select the}

\item{dists.par}{matrix  For each variable (column), specify
\itemize{
  \item{\code{par.location}: Location parameter of the desired distribution. Default 0.}
  \item{\code{par.scale}: Scale parameter of the desired distribution. Default 1.}
  \item{\code{par.shape}: Shape parameter of the desired distribution, Default 1.}
}
The number of columns must be the same as the number of variables.}

\item{mu}{vector. Two elements of the vector the first one is the mean of the reference sample and the second one is the mean of the monitoring sample.}

\item{sigma}{scalar. Standard deviation of the desired distribution.}

\item{chart}{character string. Selected type of chart. One option available: \code{"T2"}.
\describe{
  \item{T2 scheme: }{is \code{c(k)}, where \code{k} comes from \eqn{UCL = mu + k\sigma, LCL = mu - k\sigma.}}
}}

\item{chart.par}{vector. Control limit and other parameters of the selected chart.}

\item{correlation}{scalar. Corralation between variables.}

\item{s}{matrix. Correlation matrix of the variables}

\item{replicates}{scalar. Number of replicates to get the ARL}

\item{isParallel}{logical. If \code{TRUE} the code runs in parallel according to the
number of cores in the computer,otherwise the code runs sequentially. Default \code{TRUE}.}

\item{print.RL}{logical. If \code{TRUE} return the vectors of RL for each iteration.}

\item{progress}{logical. If \code{TRUE} it shows the progress in the console.}

\item{calibrate}{logical. If \code{TRUE} the RL is limit to 10 times the target ARL.}

\item{arl0}{scalar. Expected value of the RL. It is only used for stop the RL if exceeds 10 times its value. Default \code{370}.}

\item{alignment}{character string. Aligment of the data \code{X} and \code{Y}. Select from
\itemize{
  \item "unadjusted": nothing is sustracte from \code{X} and \code{Y} (default).
  \item "overallmean": overall mean is sustracted from \code{X} and \code{Y}.
  \item "overallmedian": overall median is sustracted from \code{X} and \code{Y}.
  \item "samplemean": mean from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "samplemedian": median from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "referencemean": mean from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "referencemedian": median from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "constantvalue": a constant value is subtracted from \code{X} and \code{Y}.
}}

\item{constant}{scalar. Only used when the \code{alignment} is selected "constantvalue". Default \code{NULL}.}

\item{absolute}{logical. If \code{TRUE}, the absolute aligned values are obtained. (Default \code{FALSE})}
}
\value{
Multiple output. Select by \code{output$}
\itemize{
  \item \code{ARL}: scalar. Average Run Length for the \code{RL}s of all the \code{replicates}.
  \item \code{SDRL}: scalar. Standard Deviation Run Length for the \code{RL} in all the \code{replicates}.
  \item \code{MRL}: bolean. Median Run Length for the \code{RL}s of all the \code{replicates}.
  \item \code{QRL}: vector. It retrieve the quantiles (0.05, 0.1, 0.2, 0.25, 0.5, 0.75, 0.8, 0.9, 0.95) for all the \code{RL}s.
}
}
\description{
Get the ARL \code{\link{getRL}}
}
\examples{
mgetARL(replicates=5,n=5,m=100,nv=2,mu=c(0,0),
dists = c("Normal", "Normal"), dists.par = matrix(c(0,1,1,0,1,1), ncol=2),
isParallel=FALSE)
}
