% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print_Multi.R
\name{print.SNSeg_Multi}
\alias{print.SNSeg_Multi}
\title{Print SN-based change-point estimates for multivariate time series with
dimension no greater than 10}
\usage{
\method{print}{SNSeg_Multi}(x, ...)
}
\arguments{
\item{x}{a \code{SNSeg_Multi} object}

\item{...}{not in use}
}
\description{
Print method for objects of class \code{SNSeg_Multi}
}
\examples{
\donttest{
# Please run this function before simulation
exchange_cor_matrix <- function(d, rho){
  tmp <- matrix(rho, d, d)
  diag(tmp) <- 1
  return(tmp)
}

# simulation of multivariate time series
library(mvtnorm)
set.seed(10)
d <- 5
n <- 600
nocp <- 5
cp_sets <- round(seq(0, nocp+1 ,1)/(nocp+1)*n)
mean_shift <- rep(c(0,2),100)[1:(length(cp_sets)-1)]/sqrt(d)
rho_sets <- 0.2
sigma_cross <- list(exchange_cor_matrix(d,0))
ts <- MAR_MTS_Covariance(n, 2, rho_sets, cp_sets = c(0,n), sigma_cross)
ts <- ts[1][[1]]

# Test for the change in multivariate means
# grid_size defined
result <- SNSeg_Multi(ts, paras_to_test = "mean", confidence = 0.99,
                      grid_size_scale = 0.05, grid_size = 45)
# print method
print(result)
}

}
