% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print_Uni.R
\name{print.SNSeg_Uni}
\alias{print.SNSeg_Uni}
\title{Print SN-based change-point estimates for univariate or bivariate time
series (testing the change in correlation between bivariate time series)}
\usage{
\method{print}{SNSeg_Uni}(x, ...)
}
\arguments{
\item{x}{a \code{SNSeg_Uni} object}

\item{...}{not in use}
}
\description{
Print method for objects of class \code{SNSeg_Uni}
}
\examples{
\donttest{
set.seed(7)
ts <- MAR_Variance(2, "V1")
ts <- ts[,2]
# test the change in a single parameter (variance)
# grid_size defined
result <- SNSeg_Uni(ts, paras_to_test = "variance", confidence = 0.9,
                    grid_size_scale = 0.05, grid_size = 67,
                    plot_SN = FALSE, est_cp_loc = TRUE)
print(result)
}

}
