% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatepb.R
\name{update_pb}
\alias{update_pb}
\title{Function to update the progress of a simple progress bar}
\usage{
update_pb(pb, value)
}
\arguments{
\item{pb}{Name of the progress bar to update, previously initialised with \code{create_pb()}}

\item{value}{Level of progress of the bar}
}
\value{
Prints the progress bar with the new value and returns an object of the S4 class \code{simple.progess.bar} containing:
\item{message}{A string representing the message to be printed together with the bar}
\item{bar}{The progress bar}
\item{percentage}{Progress in percentage}
\item{length}{Length of the progress bar (integer)}
\item{remaining}{Character representing the remaining operations}
\item{done}{Character representing the operations already completed}
\item{style_msg}{Styling of \code{message} using \code{crayon}}
\item{style_bar}{Styling of \code{bar} using \code{crayon}}
\item{style_perc}{Styling of \code{percentage} using \code{crayon}}
}
\description{
Function to update the progress of a simple progress bar
}
\examples{
# A single bar in a loop
pb<-create_pb(length=10, print=TRUE)
for(i in 1:10){
  cat('This is the number',i,'\n')
  pb<-update_pb(pb,i)
  Sys.sleep(.3)
  cat(pb$value,'operation completed\n')
}

\donttest{
# Two progress bars in multiple loops
pb_for<-create_pb(length=3, print=TRUE,colour='red')
for(i in 1:3){
  cat('This is the number',i,'\n')
  pb_for<-update_pb(pb_for,i)
  Sys.sleep(1)

  pb_while<-create_pb(length=i, print=TRUE,colour='blue')
  while(pb_while$value<i){
  cat('This is a subtask \n')
  pb_while<-update_pb(pb_while,pb_while$value+1)
  Sys.sleep(1)
  }
}
}

}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
