% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_AllEE5.R
\name{DA_AllEE5}
\alias{DA_AllEE5}
\title{Data Analysis for Combining (N1,M1) + (N1,M2) + (N2,M1) + (N2,M2)}
\usage{
DA_AllEE5(realdata_covariates, realdata_alpha, beta0)
}
\arguments{
\item{realdata_covariates}{a list contains the following data matrics:
CASEZ_1, CASEZ_2, CASEZhat_1, CASEZhat_2, CASEZhat_22,
CONTZ_1, CONTZ_2, CONTZhat_1, CONTZhat_2, CONTZhat_22. For details
please see definition in the help of realdata_covariates. Please be noted
that all the variables have to use the same name as listed above.}

\item{realdata_alpha}{a list contains the following data matrics:
prob_case_1, prob_case_11, prob_case_2, prob_case_22, prob_cont_1,
prob_cont_2, pwt_cont_2. details please see definition in the
help of realdata_alpha. Please be noted that all the variables have to use the same name as listed above.}

\item{beta0}{We need an initial parameter for solver "nleqslv". Default value is beta0=c(-5.4163,0.7790,-0.1289,0.2773,-0.5510,0.1568,0.4353,-0.6895)}
}
\value{
A list of estimator and its standard deviation.
}
\description{
The main function is to solve the estimating equations constructed by combining all pairs (N1,M1), (N1,M2),
(N2,M1) and (N2,M2) with selection bias probility \eqn{\pi(s,\eta)}
included.
}
\details{
The function solves GMM combined estimating equation
with handling selection bias, see Huang(2014).
}
\examples{
#you can use glm to get the estimate as the initial value of beta0
#beta0=c(-5.4163,0.7790,-0.1289,0.2773,-0.5510,0.1568,0.4353,-0.6895)
#DA_AllEE5(realdata_covariates,realdata_alpha,beta0=beta0)

}
\references{
Huang, H., Ma, X., Waagepetersen, R., Holford, T.R. , Wang, R., Risch, H., Mueller, L. & Guan, Y. (2014). A New Estimation Approach for Combining Epidemiological Data From Multiple Sources, Journal of the American Statistical Association, 109:505, 11-23.
}

