% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realdata.R
\docType{data}
\name{realdata_covariates}
\alias{realdata_covariates}
\title{A data list of matrices containing covariates of cases and controls.}
\format{A list of 10 matrices}
\usage{
realdata_covariates
}
\value{
in the first case data which has complete cases:
\enumerate{
\item CASEZ_1=\eqn{[1, Z_d, Z_t, Z_l]}
\item  CASEZhat_1=\eqn{[1, Z_d, \hat{Z}_t, Z_l]}
}

in the second case data(CTR) which has missing lifestyle covariates:
\enumerate{
\item CASEZ_2=\eqn{[1, Z_d, Z_t]}
\item CASEZhat_2=\eqn{[1, Z_d, Z_t, \hat{Z}_l]}
\item CASEZhat_22=\eqn{[1, Z_d, \hat{Z}_t, \hat{Z}_l]}
}

in the 1st control data which has complete controls:
\enumerate{
\item CONTZ_1=\eqn{[1, Z_d, Z_t, Z_l]}
\item CONTZhat_1=\eqn{[1, Z_d, Z_t, \hat{Z}_l]}
}

in the 2nd control data which has missing traffic covariates(BRFSS):
\enumerate{
\item CONTZ_2=\eqn{[1, Z_d, Z_l]}
\item CONTZhat_2=\eqn{[1, Z_d, \hat{Z}_t, Z_l]}
\item CONTZhat_22=\eqn{[1, Z_d, \hat{Z}_t, \hat{Z}_l]}
}
}
\description{
The list includes 10 matrices of covariates of cases and controls from different sources.
 Some of them need to impute the missing data, some of them need to estimate the variables
 even not missing to make sure the consistent format of input.
}
\examples{
# For example of each matrix, type the command in R: attributes(realdata_covariates)
# to obtain names of 10 bulit-in matrices in the list:
# "CASEZ_1", "CASEZhat_1", "CASEZ_2", "CASEZhat_2", "CASEZhat_22", "CONTZ_1",
# "CONTZhat_1", "CONTZ_2", "CONTZhat_2", "CONTZhat_22".

}
\keyword{datasets}

