% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_sse.R
\name{parse_sse}
\alias{parse_sse}
\title{Parse Server-Sent Events}
\usage{
parse_sse(event)
}
\arguments{
\item{event}{A length 1 string containing a server sent event as specified in
the \href{https://html.spec.whatwg.org/multipage/server-sent-events.html#server-sent-events}{HTML spec}.}
}
\value{
An R list on which each element is an event
}
\description{
This functions converts Server-Sent Events to a R list. This a wrapper function for the lower level \link{SSEparser} R6 class.
A single string can contain multiple SSEs.
}
\examples{
event <- "data: test\nevent: message\nid: 123\n\n"
parse_sse(event)

with_comment <- "data: test\n: comment\nevent: example\n\n"
parse_sse(with_comment)

}
