% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_SSM.R
\name{update.sensitivity}
\alias{update.sensitivity}
\title{Update an SSM object with the term variances and Sobol indices}
\usage{
\method{update}{sensitivity}(ssm)
}
\arguments{
\item{ssm}{An SSM object.}
}
\value{
An SSM object.
}
\description{
This function computes the term variances, Sobol indices, Total indices and
Total interaction indices of a given SSM class object.
}
\details{
This function has two modes.  If the \code{legendre} slot in the SSM object
is TRUE (\emph{i.e.} the default \code{P} matrix has been used to fit the
SSM) then all the sensitivity indices are computed assuming inputs are
uniformly distributed over \eqn{[-1, 1]^d}.  If \code{legendre} is FALSE
(\emph{i.e.} a user-defined \code{P} has been supplied) then the polynomials
defined by \code{P} are orthonormal with respect to some probability measure
and the sensitivity indices are computed assuming that measure defines the
distribution of the inputs.

The returned SSM object has term variances held in the \code{variances} slot,
ordered to match the exponent vectors in the \code{basis} slot.  The Sobol
indices are placed in \code{main_sobol} and the Total indices in
\code{total_sobol}.  The Total interaction indices are placed in the
\code{total_int} slot with identifying labels stored in
\code{total_int_factors}.  If there are less than eleven variables then
interaction indices are computed for all order interactions and stored in
\code{int_sobol} with identifying labels in \code{int_factors}.
}
\keyword{internal}

