% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile.R
\name{quantile_stressed}
\alias{quantile_stressed}
\title{Sample Quantiles of a Stressed Model}
\usage{
quantile_stressed(
  object,
  probs = seq(0, 1, 0.25),
  xCol = "all",
  wCol = 1,
  type = c("quantile", "(i-1)/(n-1)", "i/(n+1)", "i/n"),
  base = FALSE
)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{probs}{Vector of probabilities with values 
in \code{[0,1]} (\code{default = (0, 0.25, 
0.5, 0.75, 1)}).}

\item{xCol}{Numeric or character vector, (names of) the columns of 
the underlying data 
of the \code{object} (\code{default = "all"}).}

\item{wCol}{Numeric, the column of the scenario weights 
of the \code{object} (\code{default = 1}).}

\item{type}{Character, one of \code{"quantile","(i-1)/(n-1)",
"i/(n+1)","i/n"}, (\code{default  = "quantile"}). 
See details below.}

\item{base}{Logical, if \code{TRUE}, statistics under the baseline 
are also returned (\code{default = "FALSE"}).}
}
\value{
Returns a matrix with estimates of the distribution quantiles
    at the probabilities, \code{probs}, under the scenario weights 
    \code{wCol}.
}
\description{
Provides sample quantiles for components (random variables) of a 
    stochastic model, corresponding to distribution functions 
    under the scenario weights.
}
\details{


\code{type} defines the choice of algorithm used for 
    calculating the estimate of the sample quantiles.  
    \code{"quantile"} corresponds to the default interpolation used in  
    \code{\link[stats]{quantile}}. Further options are 
    \code{"(i-1)/(n-1)", "i/(n+1)", "i/n"} the inverse of the
    empirical distribution function, using, respectively, 
    \code{(wt - 1)/T, wt/(T+1), wt/T}, where \code{wt} is the 
    cumulative weight and \code{T} the total weight (usually total 
    sample size). See \code{\link[Hmisc]{wtd.quantile}} 
    for further details on \code{type}, on which
    \code{quantile_stressed} is based. \code{type} is ignored for 
    when evaluating quantiles for \code{SWIMw} objects.
}
\examples{
     
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05)
## stressed sample quantiles  
quantile_stressed(res1, probs = seq(0.9, 0.99, 0.01), wCol = 2)    
    
}
\seealso{
See \code{\link[Hmisc]{wtd.quantile}} on which the function
    \code{quantile_stressed} is based. \cr
    See \code{cdf} for the empirical distribution function of 
    a stressed model.
}
\author{
Silvana M. Pesenti, Zhuomin Mao
}
