% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILODownload}
\alias{SILODownload}
\title{Download SILO data}
\usage{
SILODownload(
  SiteList,
  username = "noemail@net.com",
  password = "gui",
  path = getwd(),
  startdate = "18890101",
  enddate = NULL,
  ssl = FALSE
)
}
\arguments{
\item{SiteList}{A station number or vector of station numbers, as a string (e.g. "24001")}

\item{username}{SILO user name. Defaults to credentials used by https://www.longpaddock.qld.gov.au/silo/point-data/}

\item{password}{SILO password}

\item{path}{Where to save the output. Will default to getwd() if not specified}

\item{startdate}{First day of data, in the format "YYYYMMDD". Will default to the first day of the record "18890101" if not specified}

\item{enddate}{Last day of data, in the format "YYYYMMDD". Will default to yesterday if not specified}

\item{ssl}{if true set ssl_cipher_list to "RC4-SHA" for file download. Seems to be necessary on some machines. default to FALSE}
}
\value{
A file for each station will be saved to path, named station number.txt. Nothing is returned to the R environment.
}
\description{
Download SILO data
}
\examples{
\dontrun{
SILODownload(c("24001","24002","24003"),
path=tempdir(),
startdate="20180101",enddate="20200101")
}

}
