% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILOFindSitesByShapefile.R
\name{SILOSitesfromPolygon}
\alias{SILOSitesfromPolygon}
\title{Find SILO sites within a polygon}
\usage{
SILOSitesfromPolygon(shpFile, ssl = FALSE, buffer = 0)
}
\arguments{
\item{shpFile}{location to a shapefile to search within for SILO sites}

\item{ssl}{See SILODownload, if true if true sets ssl_cipher_list="RC4-SHA" for httr::GET()}

\item{buffer}{distance in km to buffer the shapefile to look for sites outside the catchment

The buffer distance is approximate for a couple of reasons: the shapefile is projected to match SILO site coordinates,
WGS84 and sf::st_buffer does not correctly buffer longitude/latitude data. sdaf
Also the input distance in km is converted to degrees using the conversion at the equator of 0.008.}
}
\value{
a table of site information including site numbers found within the polygon
}
\description{
Find SILO sites within a polygon
}
\examples{
\dontrun{
Sites=SILOSitesfromPolygon("path/to/shapefile.shp")
SILODownload(Sites$Number,
path=tempdir(),
startdate="20180101",enddate="20200101")
X<-SILOLoad(Sites$Number,path=tempdir())
}
}
