% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScreeNOT.R
\name{adaptiveHardThresholding}
\alias{adaptiveHardThresholding}
\title{Adaptive hard thresholding}
\usage{
adaptiveHardThresholding(Y, k, strategy = "i")
}
\arguments{
\item{Y}{A data matrix, on whose singular values thresholding should be performed.}

\item{k}{An upper bound (potentially loose) on the latent signal rank. That
is, the procedure assumes that there are AT MOST k informative principal
components of Y.}

\item{strategy}{Method for reconstructing the noise bulk (optional). Can be one of the following:
'0': tranpsort to zero;
'w': winsorization;
'i': imputation (default option).}
}
\value{
\item{Xest}{An estimate of the low-rank signal. That is: the matrix obtained
         by thresholding the singular values of Y.}
   \item{Topt}{The hard threshold computed by the procedure. To wit, the procedure
     retains the i-th PC of Y if and only if the corresponding singular value, y_i,
       satisfies y_i > Topt.}
   \item{r}{The number of "relevant" components: r = rank(Xest).}
}
\description{
Performs optimal adaptive hard thresholding on the input matrix Y.
}
\examples{
   Y <- matrix(rnorm(1e6)/sqrt(1e3),nrow=1e3)
        # Y is a 1000x1000 i.i.d. Gaussian matrix
   val <- ScreeNOT::adaptiveHardThresholding(Y, 10)
        # Runs the ScreeNOT procedure, with an upper bound k=10
   cat('Computed threshold: ', val$Topt)
        # The adaptively computed threshold
   cat('Known optimal threshold: ', 4/sqrt(3))
        # The known optimal threshold for this noise bulk
}
\references{
David L. Donoho, Matan Gavish and Elad Romanov.
       "ScreeNOT: Exact MSE-optimal singular value thresholding in correlated noise."
       Annals of Statistics (2023).
       \url{https://github.com/eladromanov/ScreeNOT}
}
\author{
Elad Romanov
}
