% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{RES}
\alias{RES}
\title{Resolution score}
\usage{
RES(
  dt,
  bins = c(0.3, 0.35001),
  f = c("below", "normal", "above"),
  o = tc_cols(dt),
  by = by_cols_terc_fc_score(),
  pool = "year",
  dim.check = TRUE
)
}
\arguments{
\item{dt}{Data table containing the predictions.}

\item{bins}{probability bins, defaults to c("<30", "30-35",">35")}

\item{f}{column names of the prediction.}

\item{o}{column name of the observations (either in obs_dt, or in dt if obs_dt = NULL). The observation column needs to
contain -1 if it falls into the first category (corresponding to \code{fcs[1]}), 0 for the second and 1 for the third category.}

\item{by}{column names of grouping variables, all of which need to be columns in dt.
Default is to group by all instances of month, season, lon, lat, system and lead_time that are columns in dt.}

\item{pool}{column name(s) for the variable(s) along which is averaged, typically just 'year'.}

\item{dim.check}{Logical. If TRUE, the function tests whether the data table contains only one row per coordinate-level, as should be the case.}
}
\value{
A data table with the scores
}
\description{
Computes both the resolution component of the Brier score or resolution component of the Ignorance score.
Mason claims to prefer the ignorance score version, but this has a very high chance of being NA (much higher
than for the full ignorance score itself, I think we should drop it for that reason). Mason writes that the
scores are unstable for single locations and that one should pool over many locations.
Requires the specification of probability bins. One score for each category (below, normal, above) and
also the sum of the scores.
Values close to 0 means low resolution. Higher values mean higher resolution.
}
\examples{
dt = data.table(below = c(0.5,0.3,0),
                normal = c(0.3,0.3,0.7),
                above = c(0.2,0.4,0.3),
                tc_cat = c(-1,0,0),
                year = 1:3)
print(dt)
RES(dt)
}
