% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estsh.R
\name{est.sh}
\alias{est.sh}
\title{The main algorithm for estimating the Shapley value}
\usage{
est.sh(method, d, n, val, ..., p = NA, f_d = NA)
}
\arguments{
\item{method}{the method used for estimating,'SRS' meas simple random sampling, 'StrRS' means structured simple random sampling, 'LS' means Latin square and 'COA' means component orthogonal array.}

\item{d}{an integer, the number of players.}

\item{n}{an integer, the sample size.}

\item{val}{the predefined value function.}

\item{...}{other parameters used in val(sets,...).}

\item{p}{a prime, the bottom number of d.}

\item{f_d}{a vector represents the coefficients of primative polynomial on GF(d). For example the primative polynomial on GF(3^2) is x^2+x+2, then let f_d=c(1,1,2).}
}
\value{
a vector including estimated Shapley values of all players.
}
\description{
The main algorithm for estimating the Shapley value
}
\examples{
temp_adjacent<-matrix(0,nrow=8,ncol=8)
temp_adjacent[1,6:8]<-1;temp_adjacent[2,7]<-1;temp_adjacent[c(4,6,7),8]<-1;
temp_adjacent<-temp_adjacent+t(temp_adjacent)
temp_val<-function(sets,adjacent){
  if(length(sets)==1) val<-0
  else{
    subadjacent<-adjacent[sets,sets]
    nsets<-length(sets)
    A<-diag(1,nsets); B<-matrix(0,nsets,nsets)
    for(l in 1:(nsets-1)){
      A<-A\%*\%subadjacent
      B<-B+A
    }
    val<-ifelse(sum(B==0)>nsets,0,1)
  }
  return(val)
}
est.sh('SRS',8,112,temp_val,temp_adjacent)
est.sh('StrRS',8,112,temp_val,temp_adjacent)
est.sh('LS',8,112,temp_val,temp_adjacent)
est.sh('COA',8,112,temp_val,temp_adjacent,p=2,f_d=c(1,0,1,1))
}
