% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shapley_algorithm}
\alias{plot.shapley_algorithm}
\title{Barplot and tileplot of Shapley values.}
\usage{
\method{plot}{shapley_algorithm}(
  x,
  type = "both",
  subset = NULL,
  abbrev.var = FALSE,
  abbrev.obs = FALSE,
  sort.var = FALSE,
  sort.obs = FALSE,
  n_digits = 2,
  rotate_x = TRUE,
  continuous_rowname = FALSE,
  ...
)
}
\arguments{
\item{x}{A list of class \code{shapley_algorithm}.}

\item{type}{Either \code{"both"} (default), \code{"bar"}, or \code{"cell"}. If \code{"both"} (default) a barplot and a tileplot are created, otherwise only the selected plot is created.}

\item{subset}{Either an integer, \code{"chi2"}, or \code{NULL} (default) to select which rows of \code{phi} should be displayed.
If \code{NULL}, all \eqn{n} rows are displayed,
for a single integer the \code{subset} rows with the highest Mahalanobis distance are displayed,
for an integer vector the \code{subset} selected rows are displayed,
and for \code{"chi2"} all outlying rows are displayed (Mahalanobis distance greater than \eqn{\sqrt{}}\code{qchisq(chi2.q,p)}).}

\item{abbrev.var}{Integer. If \code{abbrev.var} \eqn{> 0}, column names are abbreviated using abbreviate with \code{minlenght = abrev.var}.}

\item{abbrev.obs}{Integer. If \code{abbrev.obs} \eqn{> 0}, row names are abbreviated using abbreviate with \code{minlenght = abrev.obs}.}

\item{sort.var}{Logical. If \code{TRUE} (default), variables are sorted according to the  distance}

\item{sort.obs}{Logical. If \code{TRUE} (default), observations are sorted according to their Mahalanobis distance.}

\item{n_digits}{Integer. If \code{n_digits}\eqn{ > 0}, the original values of the variables are given in each cell with \code{n_digits} decimals places.}

\item{rotate_x}{Logical. If \code{TRUE} (default), the x-axis labels are rotated.}

\item{continuous_rowname}{Logical. If \code{TRUE}, the rownames are converted to a numeric vector.}

\item{...}{Arguments passed on to \code{\link{plot.shapley}}.}
}
\value{
Returns plots for a list of class \code{shapley_algorithm}.
If \code{type} is \code{"bar"}, a barplot is generated. It displays the Shapley values (\code{\link{shapley}})
for each observation and optionally (\code{plot_md = TRUE}) includes the squared Mahalanobis distance (black bar)
and the corresponding (non-)central chi-square quantile (dotted line).
If \code{type} is \code{"cell"} a tileplot is generated. It displays each cells of the dataset and shows the original value from the observations,
color coding indicates whether those values were higher (red) or lower (blue) than the imputed values,
and the color intensity is based on the magnitude of the Shapley value.
If \code{type} is \code{"both"}, the barplot and the tileplot are generated.
}
\description{
Barplot and tileplot of Shapley values.
}
\examples{
library(MASS)
set.seed(1)
n <- 100; p <- 10
mu <- rep(0,p)
Sigma <- matrix(0.9, p, p); diag(Sigma) = 1
X <- mvrnorm(n, mu, Sigma)
X[sample(1:(n*p), 100, FALSE)] <- rep(c(-5,5),50)
MOE_X <- MOE(X, mu, Sigma)
plot(MOE_X, subset = 20, n_digits = 0)
}
