% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d18O_model.r
\name{d18O_model}
\alias{d18O_model}
\title{Function to convert SST data to d18O}
\usage{
d18O_model(SST, d18Ow = 0, transfer_function = "KimONeil97")
}
\arguments{
\item{SST}{Matrix with a time column (values in days) and an SST column
(values in degrees C)}

\item{d18Ow}{Either a single value (constant d18Ow) or a vector of length
equal to the period in SST data (365 days by default) containing information
about seasonality in d18Ow. Defaults to constant d18Ow of 0 permille VSMOW
(the modern mean ocean value)}

\item{transfer_function}{String containing the name of the transfer function
(for example: \code{"KimONeil97"} or \code{"GrossmanKu86"}). Defaults to
Kim and O'Neil (1997).}
}
\value{
A vector containing d18O values for each SST value in \code{"SST"}
}
\description{
Takes a matrix of SST data (in degrees C) against time (in days), information
about the d18O value (in permille VSMOW) of the water and how it changes
through the year and the transfer function used for of the record (e.g.
Kim and O'Neil, 1997 or Grossman and Ku, 1986). Converts the SST data to d18O
data using the supplied empirical transfer function.
}
\examples{
# Create dummy SST data
t <- seq(1, 40, 1)
T <- sin((2 * pi * (seq(1, 40, 1) - 8 + 10 / 4)) / 10)
SST <- cbind(t, T)
# Run d18O model function
d18O <- d18O_model(SST, 0, "KimONeil97")
}
\references{
Grossman, E.L., Ku, T., Oxygen and carbon isotope fractionation in biogenic
aragonite: temperature effects, \emph{Chemical Geology} \strong{1986}, \emph{59.1}, 59-74.
\doi{10.1016/0168-9622(86)90057-6}
Kim, S., O'Niel, J.R., Equilibrium and nonequilibrium oxygen
isotope effects in synthetic carbonates, \emph{Geochimica et Cosmochimica Acta}
\strong{1997}, \emph{61.16}, 3461-3475.
\doi{10.1016/S0016-7037(97)00169-5}
Dettman, D.L., Reische, A.K., Lohmann, K.C., Controls on the stable isotope
composition of seasonal growth bands in aragonitic fresh-water bivalves
(Unionidae), \emph{Geochimica et Cosmochimica Acta} \strong{1999}, \emph{63.7-8}, 1049-1057.
\doi{10.1016/S0016-7037(99)00020-4}
Brand, W.A., Coplen, T.B., Vogl, J., Rosner, M., Prohaska, T., Assessment of
international reference materials for isotope-ratio analysis (IUPAC Technical
Report), \emph{Pure and Applied Chemistry} \strong{2014}, \emph{86.3}, 425-467.
\doi{10.1515/pac-2013-1023}
}
